% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{import_IsobarQuant}
\alias{import_IsobarQuant}
\title{Import from IsobarQuant}
\usage{
import_IsobarQuant(
  proteins,
  expdesign,
  intensities = "signal_sum",
  names = "gene_name",
  ids = "protein_id",
  delim = "[|]"
)
}
\arguments{
\item{proteins}{Data.frame,
Protein table for which unique names will be created.}

\item{expdesign}{Data.frame,
Experimental design with 'label', 'condition'
and 'replicate' information.
See \code{\link{UbiLength_ExpDesign}} for an example experimental design.}

\item{intensities}{Character(1),
Prefix of the columns containing sample intensities.}

\item{names}{Character(1),
Name of the column containing feature names.}

\item{ids}{Character(1),
Name of the column containing feature IDs.}

\item{delim}{Character(1),
Sets the delimiter separating the feature names within on protein group.}
}
\value{
A SummarizedExperiment object with log2-transformed values and
"name" and "ID" columns containing unique names and identifiers.
}
\description{
\code{import_IsobarQuant} imports a protein table from IsobarQuant
and converts it into a SummarizedExperiment object.
}
\examples{
\dontrun{
# Load data
isobarquant_table <- read.csv("testfile.txt", header = TRUE,
                              stringsAsFactors = FALSE, sep = "\t")
exp_design <- read.csv("test_experimental_design.txt", header = TRUE,
                              stringsAsFactors = FALSE, sep = "\t")
# Import data
se <- import_IsobarQuant(isabarquant_table, exp_design)

}
}
