% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_functions.R
\name{LFQ}
\alias{LFQ}
\title{LFQ workflow}
\usage{
LFQ(
  proteins,
  expdesign,
  fun = c("man", "bpca", "knn", "QRILC", "MLE", "MinDet", "MinProb", "min", "zero",
    "mixed", "nbavg"),
  type = c("all", "control", "manual"),
  control = NULL,
  test = NULL,
  filter = c("Reverse", "Potential.contaminant"),
  name = "Gene.names",
  ids = "Protein.IDs",
  alpha = 0.05,
  lfc = 1
)
}
\arguments{
\item{proteins}{Data.frame,
The data object.}

\item{expdesign}{Data.frame,
The experimental design object.}

\item{fun}{"man", "bpca", "knn", "QRILC", "MLE", "MinDet",
"MinProb", "min", "zero", "mixed" or "nbavg",
Function used for data imputation based on \code{\link{manual_impute}}
and \code{\link[MSnbase:impute]{impute}}.}

\item{type}{'all', 'control' or 'manual',
The type of contrasts that will be generated.}

\item{control}{Character(1),
The sample name to which the contrasts are generated
(the control sample would be most appropriate).}

\item{test}{Character,
The contrasts that will be tested if type = "manual".
These should be formatted as "SampleA_vs_SampleB" or
c("SampleA_vs_SampleC", "SampleB_vs_SampleC").}

\item{filter}{Character,
Name(s) of the column(s) to be filtered on.}

\item{name}{Character(1),
Name of the column representing gene names.}

\item{ids}{'Character(1),
Name of the column representing protein IDs.}

\item{alpha}{Numeric(1),
sets the false discovery rate threshold.}

\item{lfc}{Numeric(1),
sets the log fold change threshold.}
}
\value{
A list of 9 objects:
\item{data}{data.frame containing the original data}
\item{se}{SummarizedExperiment object containing the original data}
\item{filt}{SummarizedExperiment object containing the filtered data}
\item{norm}{SummarizedExperiment object containing the normalized data}
\item{imputed}{SummarizedExperiment object containing the imputed data}
\item{diff}{SummarizedExperiment object
containing FDR estimates of differential expression}
\item{dep}{SummarizedExperiment object
annotated with logical columns indicating significant proteins}
\item{results}{data.frame containing containing
all results variables from the performed analysis}
\item{param}{data.frame containing the test parameters}
}
\description{
\code{LFQ} is a wrapper function running the entire
differential enrichment/expression analysis workflow
for label free quantification (LFQ)-based proteomics data.
The protein table from
\href{http://www.nature.com/nbt/journal/v26/n12/full/nbt.1511.html}{MaxQuant}
is used as direct input.
}
\examples{

data <- UbiLength
expdesign <- UbiLength_ExpDesign
results <- LFQ(data, expdesign, 'MinProb', 'control', 'Ctrl')

}
