% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateNormFactors.R
\name{simulateNormFactors}
\alias{simulateNormFactors}
\title{Simulate Normalization Factors}
\usage{
simulateNormFactors(n = 1000L, m = 6L, seed = 0L, ...)
}
\arguments{
\item{n}{number of genes}

\item{m}{number of samples}

\item{seed}{a single integer value specifying the random number generator
seed}

\item{...}{arguments passed to \code{\link[base]{matrix}}}
}
\value{
A matrix with \code{n} rows and \code{m} columns containing the
  normalization factors.
}
\description{
Simulate gene-specific normalization factors for each sample of an RNA-seq
experiment.
}
\examples{
require("DESeq2")

## normalization factors
se = simulateRnaSeqData(output = "RangedSummarizedExperiment")

dds = DESeqDataSet(se, design = ~ condition)

normalizationFactors(dds) = simulateNormFactors()
}
\seealso{
simulateRnaSeqData
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2016-2023
}
