\name{EvalConsNet}
\alias{EvalConsNet}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Evaluates the consistency of the inferred relevance correlation network with the correlations predicted by the model pathway signature.
}
\description{
This function evaluates statistical consistency of the inferred relevance network with the correlations predicted by the model pathway signature. Only if the consistency score is higher than the score expected by random chance, is it recommended to use the signature to infer pathway activity.   
}
\usage{
EvalConsNet(buildRN.o)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{buildRN.o}{Output \code{list} object from function BuildRN}
}

\value{
  A list with following entries:

   \item{netcons}{A vector summarising the properties of the network and the consistency with the prior information: nG is the number of genes in the signature, nE is the number of edges of the relevance network generated by function BuildRN, fE is the ratio of the number of edges in the relevance network to the maximum possible number, fconsE is the fraction of edges whose sign (i.e sign of correlation) is the same as the directionality predicted by the model signature, Pval(consist) is a p-value reflecting the significance of fconsE, and is estimated as the fraction of randomisations that yielded an average connectivity larger than the observed one.}
   \item{netsign}{A matrix of dimension 2 times number of edges in network comparing directionality of prior info and that in the observed data}
   \item{adj}{Adjacency matrix of inferred relevance network}
   \item{s}{Model signature vector}
   \item{c}{Correlation matrix between model signature genes}
}
\references{{Jiao Y, Lawler K, Patel GS, Purushotham A, Jones AF, Grigoriadis A, Ng T, Teschendorff AE. (2011)  Denoising algorithm based on relevance network topology improves molecular pathway activity inference. BMC Bioinformatics 12:403.}

{Teschendorff AE, Gomez S, Arenas A, El-Ashry D, Schmidt M, et al. (2010) Improved prognostic classification of breast
cancer defined by antagonistic activation patterns of immune response pathway modules. BMC Cancer 10:604.}

}
\author{Andrew E Teschendorff, Yan Jiao}

\examples{

data(dataDART)
rn.o <- BuildRN(dataDART$data, dataDART$sign, fdr=0.05)
evalNet.o <- EvalConsNet(rn.o)
## See ?DoDART and vignette('DART') for further examples.
 
  
}


