% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesImputation_PeptideLevel.R
\name{wrapper.dapar.impute.mi}
\alias{wrapper.dapar.impute.mi}
\title{Missing values imputation using the LSimpute algorithm.}
\usage{
wrapper.dapar.impute.mi(
  obj,
  nb.iter = 3,
  nknn = 15,
  selec = 600,
  siz = 500,
  weight = 1,
  ind.comp = 1,
  progress.bar = FALSE,
  x.step.mod = 300,
  x.step.pi = 300,
  nb.rei = 100,
  method = 4,
  gridsize = 300,
  q = 0.95,
  q.min = 0,
  q.norm = 3,
  eps = 0,
  methodi = "slsa",
  lapala = TRUE,
  distribution = "unif"
)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}

\item{nb.iter}{Same as the function \code{mi.mix} in the package \code{imp4p}}

\item{nknn}{Same as the function \code{mi.mix} in the package \code{imp4p}}

\item{selec}{Same as the function \code{mi.mix} in the package \code{imp4p}}

\item{siz}{Same as the function \code{mi.mix} in the package \code{imp4p}}

\item{weight}{Same as the function \code{mi.mix} in the package \code{imp4p}}

\item{ind.comp}{Same as the function \code{mi.mix} in the package
\code{imp4p}}

\item{progress.bar}{Same as the function \code{mi.mix} in the package
\code{imp4p}}

\item{x.step.mod}{Same as the function \code{estim.mix} in the package
\code{imp4p}}

\item{x.step.pi}{Same as the function \code{estim.mix} in the package
\code{imp4p}}

\item{nb.rei}{Same as the function \code{estim.mix} in the package
\code{imp4p}}

\item{method}{Same as the function \code{estim.mix} in the package
\code{imp4p}}

\item{gridsize}{Same as the function \code{estim.mix} in the package
\code{imp4p}}

\item{q}{Same as the function \code{mi.mix} in the package \code{imp4p}}

\item{q.min}{Same as the function \code{impute.pa} in the package
\code{imp4p}}

\item{q.norm}{Same as the function \code{impute.pa} in the package
\code{imp4p}}

\item{eps}{Same as the function \code{impute.pa} in the package \code{imp4p}}

\item{methodi}{Same as the function \code{mi.mix} in the package \code{imp4p}}

\item{lapala}{xxxxxxxxxxx}

\item{distribution}{The type of distribution used. Values are \code{unif}
(default) or \code{beta}.}
}
\value{
The \code{Biobase::exprs(obj)} matrix with imputed values 
instead of missing values.
}
\description{
This method is a wrapper to the function \code{impute.mi()} of the package
\code{imp4p} adapted to an object of class \code{MSnSet}.
}
\examples{
utils::data(Exp1_R25_pept, package = "DAPARdata")
obj <- Exp1_R25_pept[seq_len(100)]
level <- 'peptide'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj.imp.na <- wrapper.dapar.impute.mi(obj, nb.iter = 1, lapala = TRUE)
obj.imp.pov <- wrapper.dapar.impute.mi(obj, nb.iter = 1, lapala = FALSE)

}
\author{
Samuel Wieczorek
}
