% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inOutFiles.R
\name{rbindMSnset}
\alias{rbindMSnset}
\title{Similar to the function \code{rbind} but applies on two subsets of
the same \code{MSnSet} object.}
\usage{
rbindMSnset(df1 = NULL, df2)
}
\arguments{
\item{df1}{An object (or subset of) of class \code{MSnSet}. May be NULL}

\item{df2}{A subset of the same object as df1}
}
\value{
An instance of class \code{MSnSet}.
}
\description{
Similar to the function \code{rbind} but applies on two subsets of
the same \code{MSnSet} object.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
df1 <- Exp1_R25_pept[seq_len(100)]
df2 <- Exp1_R25_pept[seq.int(from = 200, to = 250)]
rbindMSnset(df1, df2)

}
\author{
Samuel Wieczorek
}
