% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell.R
\name{match.metacell}
\alias{match.metacell}
\title{Similar to the function \code{is.na} but focused on the equality
with the paramter 'type'.}
\usage{
match.metacell(metadata, pattern = NULL, level)
}
\arguments{
\item{metadata}{A data.frame}

\item{pattern}{The value to search in the dataframe}

\item{level}{xxx}
}
\value{
A boolean dataframe
}
\description{
Similar to the function \code{is.na} but focused on the equality
with the paramter 'type'.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(10), ]
metadata <- GetMetacell(obj)
m <- match.metacell(metadata, pattern = "Missing", level = "peptide")
m <- match.metacell(metadata, pattern = NULL, level = "peptide")
m <- match.metacell(metadata, pattern = c('Missing', 'Missing POV'), level = "peptide")
}
\author{
Samuel Wieczorek
}
