% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSelectedWorkflow}
\alias{plotSelectedWorkflow}
\title{Plot a pipeline workflow from a CytoPipeline run}
\usage{
plotSelectedWorkflow(experimentName, whichQueue, sampleFile, path = path)
}
\arguments{
\item{experimentName}{the experiment name (representing a pipeline run)
from which to extract the workflow}

\item{whichQueue}{"pre-processing" or "scale transform"}

\item{sampleFile}{in case 'whichQueue' is set to 'pre-processing, which
sample file to look at. This can be a number or a character.
\itemize{
\item if whichQueue == "scale transform", the sampleFile is ignored
\item if NULL and whichQueue == "pre-processing", the sampleFile is defaulted
to the first one belonging to the experiment
}}

\item{path}{the root path to look for the CytoPipeline experiment cache}
}
\value{
nothing, but displays the plot as a side effect
}
\description{
Plot a pipeline workflow from a CytoPipeline run
}
\examples{

# run CytoPipeline object first

outputDir <- base::tempdir()


rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- 
    file.path(
        rawDataDir, 
        list.files(rawDataDir, pattern = "Donor"))
jsonDir <- system.file("extdata", package = "CytoPipeline")
jsonPath <- file.path(jsonDir, "pipelineParams.json")

pipL2 <- CytoPipeline(
    jsonPath,
    experimentName = experimentName,
    sampleFiles = sampleFiles)

suppressWarnings(execute(
    pipL2,
    rmCache = TRUE,
    path = outputDir))

plotSelectedWorkflow(
    experimentName = experimentName,
    whichQueue = "pre-processing",
    sampleFile = sampleFiles[1],
    path = outputDir)
    
plotSelectedWorkflow(
    experimentName = experimentName,
    whichQueue = "scale transform",
    sampleFile = NULL,
    path = outputDir)


}
