% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoMDS-package.R
\docType{package}
\name{CytoMDS-package}
\alias{CytoMDS}
\alias{CytoMDS-package}
\title{CytoMDS: Low Dimensions projection of cytometry samples}
\description{
This package implements a low dimensional visualization of a set of cytometry samples, in order to visually assess the 'distances' between them. This, in turn, can greatly help the user to identify quality issues like batch effects or outlier samples, and/or check the presence of potential sample clusters that might align with the exeprimental design. The CytoMDS algorithm combines, on the one hand, the concept of Earth Mover's Distance (EMD), a.k.a. Wasserstein metric and, on the other hand, the Multi Dimensional Scaling (MDS) algorithm for the low dimensional projection. Also, the package provides some diagnostic tools for both checking the quality of the MDS projection, as well as tools to help with the interpretation of the axes of the projection.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://uclouvain-cbio.github.io/CytoMDS}
  \item Report bugs at \url{https://github.com/UCLouvain-CBIO/CytoMDS/issues}
}

}
\author{
\strong{Maintainer}: Philippe Hauchamps \email{philippe.hauchamps@uclouvain.be} (\href{https://orcid.org/0000-0003-2865-1852}{ORCID})

Authors:
\itemize{
  \item Laurent Gatto \email{laurent.gatto@uclouvain.be} (\href{https://orcid.org/0000-0002-1520-2268}{ORCID})
}

Other contributors:
\itemize{
  \item Dan Lin \email{dan.8.lin@gsk.com} [contributor]
}

}
\keyword{internal}
