% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cytoglm.R
\name{summary.cytoglm}
\alias{summary.cytoglm}
\title{Extact and calculate p-values of bootstrap GLM fit}
\usage{
\method{summary}{cytoglm}(object, method = "BH", ...)
}
\arguments{
\item{object}{A \code{cytoglm} class}

\item{method}{Multiple comparison adjustment method}

\item{...}{Other parameters}
}
\value{
\code{\link[tibble]{tibble}} data frame
}
\description{
Extact and calculate p-values of bootstrap GLM fit
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
glm_fit <- CytoGLMM::cytoglm(df,
                             protein_names = protein_names,
                             condition = "condition",
                             group = "donor",
                             num_boot = 10) # in practice >=1000
summary(glm_fit)
}
