% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{get_seurat}
\alias{get_seurat}
\title{Given a data frame of HCA metadata, returns a Seurat object corresponding to
the samples in that data frame}
\usage{
get_seurat(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=get_single_cell_experiment]{get_single_cell_experiment}}
  \describe{
    \item{\code{data}}{A data frame containing, at minimum, a \code{sample_} column, which
corresponds to a single cell sample ID. This can be obtained from the
\code{\link[=get_metadata]{get_metadata()}} function.}
    \item{\code{assays}}{A character vector whose elements must be either "counts"
and/or "cpm", representing the corresponding assay(s) you want to request.
By default only the count assay is downloaded. If you are interested in
comparing a limited amount of genes, the "cpm" assay is more appropriate.}
    \item{\code{repository}}{A character vector of length one. If provided, it should be
an HTTP URL pointing to the location where the single cell data is stored.}
    \item{\code{cache_directory}}{An optional character vector of length one. If
provided, it should indicate a local file path where any remotely accessed
files should be copied.}
    \item{\code{features}}{An optional character vector of features (ie genes) to return
the counts for. By default counts for all features will be returned.}
  }}
}
\value{
A Seurat object containing the same data as a call to
\code{\link[=get_single_cell_experiment]{get_single_cell_experiment()}}
}
\description{
Given a data frame of HCA metadata, returns a Seurat object corresponding to
the samples in that data frame
}
\examples{
meta <- get_metadata() |> head(2)
seurat <- get_seurat(meta)

}
