% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotChimeras.R
\name{plotChimeras}
\alias{plotChimeras}
\title{Display a dot plot of chimeric alignments}
\usage{
plotChimeras(
  chimeric.alns,
  max.gap = 10,
  tick.sep = 20,
  text.size = 10,
  title.size = 16,
  gap.pad = 20,
  legend.title = "Chromosome",
  xangle = 90,
  wrt.forward = FALSE,
  annotate.within = 20,
  annotations = GenomicRanges::GRanges()
)
}
\arguments{
\item{chimeric.alns}{A GAlignments object containing only the chimeric
reads to be plotted}

\item{max.gap}{If aligned segments are separated by more than max.gap,}

\item{tick.sep}{How many bases should separate tick labels on plot.  Default 20.}

\item{text.size}{Size of X and Y tick labels on plot.  Default 12}

\item{title.size}{Size of X and Y axis labels on plot.  Default 16}

\item{gap.pad}{How much should aligned blocks be separated by?  (Default: 20)}

\item{legend.title}{Title for the legend.  Default "Chromosome"}

\item{xangle}{Angle for x axis text (Default 90, i.e vertical)}

\item{wrt.forward}{Should chimeric alignments where all members map to the
negative strand be displayed with respect to the forward strand, i.e. as the
cigar strand is written (TRUE), or the negative strand (FALSE) (Default: FALSE)}

\item{annotate.within}{annot_aln ranges in "annotations" within n bases of a chimeric
alignment (Default 50)}

\item{annotations}{A list of GRanges.  Any that overlap with the chimeric alignments
are highlighed in the plot.}
}
\value{
A ggplot2 dotplot of the chimeric alignments versus the reference sequence
}
\description{
Produces a dot plot of a set of chimeric alignments.  For chimeric alignments,
a single read is split into several, possibly overlapping alignmed blocks.
Aligned sections of chimeric reads can be separated by large genomic distances,
or on separate chromosomes.  plotChimeras produces a dot plot, each aligned block
highlighted, and chromosomes shown in different colours. Large gaps between
aligned segments are collapsed and indicated on the plot with horizontal lines.
The X-axis shows each base of the entire read. Note that the mapping to the fwd strand
is shown if all strands agree.  The chimeric alignments must be sorted!
}
\examples{
bam_fname <- system.file("extdata", "gol_F1_clutch_2_embryo_4_s.bam",
                         package = "CrispRVariants")
bam <- GenomicAlignments::readGAlignments(bam_fname, use.names = TRUE)
# Choose a single chimeric read set to plot:
chimeras <- bam[names(bam) == "AB3092"]

# This read aligns in 3 pieces, all on chromosome 18.
# The plot shows the alignment annot_alns a small duplication and
# a long gap.
plotChimeras(chimeras)
}
\seealso{
\code{\link{findChimeras}} for finding chimeric alignment sets.
}
\author{
Helen Lindsay
}
