% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreatmentResponseExperiment-class.R,
%   R/methods-coerce.R
\name{as}
\alias{as}
\title{Coerce a \code{LongTable} to a \code{TreatmentResponseExperiment}}
\arguments{
\item{from}{A \code{LongTableDataMapper} to coerce.}
}
\value{
The data in \code{object}, as the child-class
\code{TreatmentResponseExperiment}.

A \code{data.table} with the data from a LongTable.

\code{data.table} containing the data from the LongTable, with the
`longTableDataMapper' attribute containg the metadata needed to reverse
the coercing operation.

\code{LongTable} object configured with the longTableDataMapper

\code{data.table} with long format of data in \code{from}

\code{data.frame} with long format of data in \code{from}.

\code{SummarizedExperiment} with each assay as a \code{BumpyMatrix}

A \code{TREDataMapper} object.
}
\description{
Coerce a LongTable into a \code{data.table}.

Currently only supports coercing to data.table or data.frame

Coerce a data.table with the proper configuration attributes
back to a LongTable
}
\examples{
data(clevelandSmall_cSet)
TRE <- as(treatmentResponse(clevelandSmall_cSet),
    "TreatmentResponseExperiment")
TRE

as(merckLongTable, 'data.table')

dataTable <- as(merckLongTable, 'data.table')
print(attr(dataTable, 'longTableDataMapper')) # Method doesn't work without this
as(dataTable, 'LongTable')

SE <- molecularProfilesSlot(clevelandSmall_cSet)[[1]]
as(SE, 'data.table')

SE <- molecularProfilesSlot(clevelandSmall_cSet)[[1]]
as(SE, 'data.frame')

}
\seealso{
\code{\link{TreatmentResponseExperiment}}

\code{\link[BumpyMatrix:BumpyMatrix]{BumpyMatrix::BumpyMatrix}}
}
