#' Cleaveland_mut RadioSet subsetted and cast as CoreSet
#'
#' This dataset is just a dummy object derived from the Cleveland_mut RadioSet
#'   in the RadioGx R package. It's contents should not be interpreted and it
#'   is only present to test the functions in this package and provide
#'   examples
#' 
#' @references
#' Lamb et al. The Connectivity Map: using gene-expression signatures to connect 
#' small molecules, genes, and disease. Science, 2006.
#' 
#' @docType data
#' @name clevelandSmall_cSet
#' @usage data(clevelandSmall_cSet)
#' @keywords datasets
#' @format CoreSet object
NULL

#' Merck Drug Combination Data LongTable
#'
#' This is a LongTable object created from some drug combination data provided
#'   to our lab by Merck.
#'
#' @references
#' TODO:: Include a reference
#'
#' @docType data
#' @name merckLongTable
#' @usage data(merckLongTable)
#' @keywords datasets
#' @format LongTable object
NULL

#' Example LongTableDataMapper
#'
#' A dummy LongTableDataMapper object to be used in package examples.
#'
#' @docType data
#' @name exampleDataMapper
#' @usage data(exampleDataMapper)
#' @keywords datasets
#' @format LongTableDataMapper object
NULL

#' NCI-ALMANAC Drug Combination Data TreatmentResponseExperiment Subset
#'
#' This is a `TreatmentResponseExperiment` object containing a subset of
#'   NCI-ALMANAC drug combination screening data,
#'   with 2347 unique treatment combinations on 10 cancer cell lines selected.
#'
#' @references
#' Susan L. Holbeck, Richard Camalier, James A. Crowell, Jeevan Prasaad Govindharajulu, Melinda Hollingshead, Lawrence W. Anderson, Eric Polley, Larry Rubinstein, Apurva Srivastava, Deborah Wilsker, Jerry M. Collins, James H. Doroshow; The National Cancer Institute ALMANAC: A Comprehensive Screening Resource for the Detection of Anticancer Drug Pairs with Enhanced Therapeutic Activity. Cancer Res 1 July 2017; 77 (13): 3564–3576. https://doi.org/10.1158/0008-5472.CAN-17-0489
#'
#' @docType data
#' @name nci_TRE_small
#' @usage data(nci_TRE_small)
#' @keywords datasets
#' @format TreatmentResponseExperiment object
NULL