% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLRR.R
\name{plotLRR}
\alias{plotLRR}
\title{plotLRR}
\usage{
plotLRR(karyoplot, snps, lrr.column="lrr", labels="LRR", ymin=-4, ymax=2, out.of.range = "points", out.of.range.col="red", density.height=0.05, density.window=1e5, line.at.0 = TRUE, line.at.0.col="blue", r0=0, r1=1, points.cex=0.3, points.col="#333333", points.pch=16, label.cex=1.5, label.srt=90, label.margin=0.03, add.axis=TRUE, axis.cex=1.2, track.margin=0.1, data.panel=1,  verbose=FALSE, ...)
}
\arguments{
\item{karyoplot}{(a KaryoPlot object) The object returned by the \code{\link[karyoploteR]{plotKaryotype}} function and representing the current active plot.}

\item{snps}{(a GRanges, a list of GRanges or a GRangesList) An object with the positions of the SNPs and a column with the LRR values. Other columns are ignored. If it's a list of GRanges with different samples, all samples will be plotted, splitting the total plot space between them.}

\item{lrr.column}{(number or character) The name or number of the column with LRR information. (defaults to "lrr")}

\item{labels}{(character) The text of the label to identify the data. If NA, no label will be plotted. If NULL, if snps is a single sample GRanges it will default to "LRR", if it's a list of samples it will default to the names in the list or consecutive numbers if names(snps) is NULL.(defaults to "LRR")}

\item{ymin}{(numeric) (karyoploteR parameter) The minimum value of y to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to -4)}

\item{ymax}{(numeric) (karyoploteR parameter) (numeric) The maximum value of y to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to 2)}

\item{out.of.range}{(a character) Either to plot "points" or "density" (defaults to  "points")}

\item{out.of.range.col}{The color the out-of-range points should be plotted (defaults to "red")}

\item{density.height}{The height of the maximum density peak if out.of.range is "density" (defaults to 0.05)}

\item{density.window}{The window used to compute the uot-of-range density (defaults to 1e5)}

\item{line.at.0}{(logical) Whether to plot an horizontal line at 0. (defaults to  TRUE)}

\item{line.at.0.col}{(color) The color of the horizontal line plotted at 0. (defaults to "blue")}

\item{r0}{(numeric) (karyoploteR parameter) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) (karyoploteR parameter) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{points.cex}{(numeric) The size of the points. (defaults to 0.3)}

\item{points.col}{(a color) The color of the points (defaults to "#333333")}

\item{points.pch}{(numeric) The shape of the points. (defaults to 16, a filled circle)}

\item{label.cex}{(numeric) The size of the label (defaults to 1.5)}

\item{label.srt}{(numeric) The rotation of the label (defaults to 90, vertical text)}

\item{label.margin}{(numeric) The margin between the label and the origin of the plot in plot coordinates (the width of the plot is 1). (defaults to 0.03)}

\item{add.axis}{(logical) Whether to add an axis (defaults to TRUE)}

\item{axis.cex}{(numeric) The size of the axis labels.  (defaults to 1.2)}

\item{track.margin}{(numeric) If snps is a list object, this is the margin between the samples BAF. (deafults to 0.1)}

\item{data.panel}{(numeric) (karyoploteR parameter) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{verbose}{(logical) Wether messages with information on the processing should be generated (defaults to FALSE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to karyoploteR functions.}
}
\value{
Invisibly returns the karyoplot object representing the plot. With it
it is possible to add other elements to the plot using standrad karyoploteR
functions
}
\description{
Plots the raw SNP array data using karyoploteR
}
\details{
Creates a plot with the LRR values along the genome
}
\examples{

pos <- floor(runif(1000, 1, 10000))
lrr.data <- toGRanges("chr1", pos, pos)
lrr.data$lrr <- rnorm(1000, mean = 0, sd = 0.3)

kp <- plotKaryotype(zoom=toGRanges("chr1", 1, 10000))
plotLRR(kp, lrr.data)


kp <- plotKaryotype(zoom=toGRanges("chr1", 1, 10000))
plotLRR(kp, lrr.data, lrr.column=1, points.col="orange", labels="First", label.cex=0.8, points.cex=1.4)


}
