% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSNPDataFromVCF.R
\name{loadSNPDataFromVCF}
\alias{loadSNPDataFromVCF}
\title{loadSNPDataFromVCF}
\usage{
loadSNPDataFromVCF(vcf.file, regions=NULL, genome="hg19", mirror.baf=TRUE, verbose=TRUE)
}
\arguments{
\item{vcf.file}{The name of the VCF file with the data}

\item{regions}{The regions to which we will limit the import (defaults to NULL)}

\item{genome}{(a character)The name of the genome (defaults to "hg19")}

\item{mirror.baf}{Flip the baf of about half the snps (the ones in odd positions in the genome) to achieve a mirror-like effect as in SNP arrays (defaults to TRUE)}

\item{verbose}{Wether information messages should be generated. (defaults to TRUE)}
}
\value{
A GRanges object with a range per variant and a column named baf
}
\description{
Load BAF-like data from a VCF file based on the variant allele frequency
}
\details{
Given a VCF file the function will compute BAF-like values based on the
variant allele frequency contained in it and return a GRanges object
with a column named "baf".
}
\examples{

vcf.file <- system.file("extdata", "example.vcf.gz", package = "CopyNumberPlots", mustWork = TRUE)
# These examples fail in windows. Commenting them out temporarily
# snps <- loadSNPDataFromVCF(vcf.file)

#kp <- plotKaryotype(plot.type = 4)
#plotBAF(kp, snps = snps, labels = names(snps))

}
