% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneGroupTwoLabelsCoMigration.R
\name{oneGroupTwoLabelsCoMigration}
\alias{oneGroupTwoLabelsCoMigration}
\title{Compare a Single Group of Proteins Between Two Label States}
\usage{
oneGroupTwoLabelsCoMigration(
  dataFrame,
  max_frac,
  groupData = NULL,
  groupName = "group1",
  meanLine = FALSE,
  medianLine = FALSE,
  ylabel = "Relative Protein Abundance",
  xlabel = "Fraction",
  legendLabel = "Condition",
  labelled = "Labeled",
  unlabelled = "Unlabeled",
  jitterPoints = 0.3,
  pointSize = 2.5,
  grid = FALSE,
  titleAlign = "left",
  alphaValue = 1,
  controlSample = "",
  textSize = 12,
  axisTextSize = 8
)
}
\arguments{
\item{dataFrame}{dataFrame: data frame, data frame of normalised values for
proteins from SCENARIO A,
          contains columns:
         `Protein Group Accessions` character
         `Protein Descriptions` character
          Fraction integer
          isLabel character ('TRUE'/'FALSE' values)
          `Precursor Area` double
          scenario character}

\item{max_frac}{numeric, total number of fractions}

\item{groupData}{character vector, contins list of Protein Group Accessions 
that belong to the group we want to plot}

\item{groupName}{character, name that should be used for the group specified 
in groupData}

\item{meanLine}{logical, specifies whether to plot a mean line for all values
in the group}

\item{medianLine}{logical, specifies whether to plot a median line for all 
values in the group}

\item{ylabel}{character}

\item{xlabel}{character}

\item{legendLabel}{character}

\item{labelled}{character, label to be used for isLabel == TRUE}

\item{unlabelled}{character, label to be used for isLabel == FALSE}

\item{jitterPoints}{numeric}

\item{pointSize}{numeric, size of the point in the plot}

\item{grid}{logical, specifies presence/absence of gridline in the plot}

\item{titleAlign}{character, one of the 'left', 'center'/'centre', 'right',
specifies alignment of the title in plot}

\item{alphaValue}{numeric, transparency of the point, values 0 to 1}

\item{controlSample}{character, either labelled or unlabelled, this setting
will adjust plot coloring based on which sample is a control}

\item{textSize}{numeric, size of text in the plot}

\item{axisTextSize}{numeric, size of axis labels in the plot}
}
\value{
plot
}
\description{
This function creates a ?scatter plot? for a subset of proteins in dataFrame
specified in groupData. Intended use of the function - using scenario A data,
compare shape of the migration profile for a SINGLE GROUP of proteins BETWEEN
the two LABEL STATES.
}
\examples{

##Use example normalised proteins file
inputFile <- system.file("extData", "dataNormProts.txt", package = "ComPrAn")
#read file in and change structure of table to required format
forAnalysis <- protImportForAnalysis(inputFile)
##example plot:
groupDV <- c("Q16540","P52815","P09001","Q13405","Q9H2W6")
groupName <- 'group1' 
max_frac <- 23 
oneGroupTwoLabelsCoMigration(forAnalysis, max_frac, groupDV,groupName)

}
