% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{getSimilarities}
\alias{getSimilarities}
\title{Match one spectrum against a set of spectra}
\usage{
getSimilarities(spec, speclist, type = c("spectrum", "neutral_losses"),
    hits_only = FALSE)
}
\arguments{
\item{spec}{The spectrum to be compared to other spectra. Can be either an
object of class \code{\linkS4class{MS2spectrum}} or a two-column numerical
matrix that contains fragment mass-to-charge ratios in the first and
intensities in the second column.}

\item{speclist}{The set of spectra to which \code{spec} is to be compared.
Must be a list where every entry is an object of class
\code{\linkS4class{MS2spectrum}}. Can be generated from an mzXML file with
\code{\link{extractMS2spectra}} and \code{\link{mergeMS2spectra}} or
constructed using \code{new("MS2spectrum", ...)} for every list entry (see
vignette for details).}

\item{type}{Specifies whether MS2 spectra or neutral loss patterns are to be
compared. Must be either \code{'spectrum'} (default) or
\code{'neutral_losses'}.}

\item{hits_only}{Logical that indicates whether the result should contain
only similarities greater than zero.}
}
\value{
A named vector with similarities of \code{spec} to all spectra or
    neutral loss patterns in \code{speclist}.
}
\description{
\code{getSimilarities} calculates the similarities of one spectrum or
neutral loss pattern to a set of other spectra or neutral loss patterns.
}
\examples{
load(file = system.file("extdata",
    "annotatedSpeclist.RData",
    package = "CluMSIDdata"))
getSimilarities(annotatedSpeclist[[137]],
                annotatedSpeclist, hits_only = TRUE)

}
