% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ligandReceptor_analysis.R
\name{ligandReceptorTest}
\alias{ligandReceptorTest}
\title{ligandReceptorTest}
\usage{
ligandReceptorTest(
  sce,
  ligandReceptor_list,
  cluster,
  RNA_exprs_value = "minMax",
  use_alt_exp = TRUE,
  altExp_name = "ADT",
  altExp_exprs_value = "zi_minMax",
  num_permute = 1000,
  p_sig = 0.05
)
}
\arguments{
\item{sce}{A singlecellexperiment object}

\item{ligandReceptor_list}{A data.frame indicates the ligand receptor list}

\item{cluster}{A vector indicates the cluster results}

\item{RNA_exprs_value}{A character indicates which expression value
for RNA in assayNames is used.}

\item{use_alt_exp}{A logical vector indicates whether receptors
expression will use alternative expression matrix to quantify.}

\item{altExp_name}{A character indicates which expression matrix is used.
by default is ADT .}

\item{altExp_exprs_value}{A character indicates which expression value
in assayNames is used.}

\item{num_permute}{Number of permutation.}

\item{p_sig}{A numeric indicates threshold of the pvalue significance}
}
\value{
A SingleCellExperiment object with ligand receptor results
}
\description{
A function to perform ligand receptor analysis
}
\examples{
data(lr_pair_subset, package = "CiteFuse")
data(sce_control_subset, package = "CiteFuse")

sce_control_subset <- normaliseExprs(sce = sce_control_subset,
altExp_name = "ADT",
transform = "zi_minMax")

sce_control_subset <- normaliseExprs(sce = sce_control_subset,
                              altExp_name = "none",
                              exprs_value = "logcounts",
                              transform = "minMax")

sce_control_subset <- ligandReceptorTest(sce = sce_control_subset,
                                  ligandReceptor_list = lr_pair_subset,
                                  cluster = sce_control_subset$SNF_W_louvain,
                                  RNA_exprs_value = "minMax",
                                  use_alt_exp = TRUE,
                                  altExp_name = "ADT",
                                  altExp_exprs_value = "zi_minMax",
                                  num_permute = 100)
}
