% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment.R
\name{align_reads}
\alias{align_reads}
\title{Align sequence reads to a genome sequence}
\usage{
align_reads(
  input,
  index,
  output,
  n_threads = 1,
  n_mismatch = 1,
  overwrite = TRUE,
  aligner = c("hisat2", "bowtie2"),
  add_args = NULL
)
}
\arguments{
\item{input}{A path to a FASTQ format file for alignment.}

\item{index}{A \code{\link{CircSeqAlignTkRefIndex-class}} object generated by
the \code{\link{build_index}} function.}

\item{output}{A path to a directory for saving the intermediate and final
results of alignment.}

\item{n_threads}{Number of threads to use for aligning reads.}

\item{n_mismatch}{Number of allowed mismatches in alignment.}

\item{overwrite}{Overwrite the existing files if \code{TRUE}.}

\item{aligner}{A string to specify the alignment is for alignment.}

\item{add_args}{A string of additional arguments to be passed on to the
alignment tool directly.
For example, \code{-N 0 -L 22}, \code{--no-spliced-alignment -k 10}, etc.}
}
\value{
A \code{\link{CircSeqAlignTkAlign-class}} object.
}
\description{
This function aligns sequence reads in a FASTQ file
to the reference sequences of a genome.
}
\details{
This function aligns sequence reads in a FASTQ format file in two stages:
(i) aligning reads to the type 1 reference sequence (i.e., \code{refseq.t1.fa})
and (ii) collecting the unaligned reads
and aligning them with the type 2 reference (i.e., \code{refseq.t2.fa}).
The alignment results are saved as BAM format files
in the specified directory with the suffixes \verb{*.t1.bam} and \verb{*.t2.bam}.
The original alignment results may contain mismatches.
Hence, filtering is performed to remove the alignment with mismatches
over the specified value from the BAM format file.
The filtered results of the \verb{*.t1.bam} and \verb{*.t2.bam} are saved as
\verb{*.clean.t1.bam} and \verb{*.clean.t2.bam}, respectively.

Two alignment tools (Bowtie2 and HISAT2) can be specified
for building indexes through the aligner argument.
This function first attempts to call the specified alignment tool
installed on the operation system directly;
however, if the tool is not installed,
then the function attempts to call
\code{\link[Rbowtie2]{bowtie2_build}} or \code{\link[Rhisat2]{hisat2_build}}
functions implemented in the Rbowtie2 or Rhisat2 packages for alignment.
}
\examples{
output_dpath <- tempdir()

genome_seq <- system.file(package="CircSeqAlignTk", "extdata", "FR851463.fa")
fq <- system.file(package="CircSeqAlignTk", "extdata", "srna.fq.gz")

ref_index <- build_index(input = genome_seq,
                         output = file.path(output_dpath, 'index'))
aln <- align_reads(input = fq, index = ref_index,
                   output = file.path(output_dpath, 'align_results'))

slot(aln, 'stats')
}
\seealso{
\code{\link{CircSeqAlignTkAlign-class}}
}
