% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_inter_correlation_scExp}
\alias{plot_inter_correlation_scExp}
\title{Violin plot of inter-correlation distribution between one or multiple groups
and one reference group}
\usage{
plot_inter_correlation_scExp(
  scExp_cf,
  by = c("sample_id", "cell_cluster")[1],
  jitter_by = NULL,
  reference_group = unique(scExp_cf[[by]])[1],
  other_groups = unique(scExp_cf[[by]]),
  downsample = 5000
)
}
\arguments{
\item{scExp_cf}{A SingleCellExperiment}

\item{by}{Color by sample_id or cell_cluster}

\item{jitter_by}{Add jitter points of another layer
(cell_cluster or sample_id)}

\item{reference_group}{Character containing the reference group name to
calculate correlation from.}

\item{other_groups}{Character vector of the other groups for which to
calculate correlation with the reference group.}

\item{downsample}{Downsample for plotting}
}
\value{
A violin plot of inter-correlation
}
\description{
Violin plot of inter-correlation distribution between one or multiple groups
and one reference group
}
\examples{
data(scExp)
plot_intra_correlation_scExp(scExp)
}
