% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_differential_summary_scExp}
\alias{plot_differential_summary_scExp}
\title{Differential summary barplot}
\usage{
plot_differential_summary_scExp(
  scExp_cf,
  qval.th = 0.01,
  logFC.th = 1,
  min.percent = 0.01
)
}
\arguments{
\item{scExp_cf}{A SingleCellExperiment object}

\item{qval.th}{Adjusted p-value threshold. (0.01)}

\item{logFC.th}{Fold change threshold. (1)}

\item{min.percent}{Minimum fraction of cells having the feature active to
consider it as significantly differential. (0.01)}
}
\value{
A barplot summary of differential analysis
}
\description{
Differential summary barplot
}
\examples{
data("scExp")
plot_differential_summary_scExp(scExp)
}
