% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_number.R
\name{get_cyto_features}
\alias{get_cyto_features}
\title{Map features onto cytobands}
\usage{
get_cyto_features(scExp, ref_genome = c("hg38", "mm10", "ce11")[1])
}
\arguments{
\item{scExp}{A SingleCellExperiment with genomic coordinate as features
(peaks or bins)}

\item{ref_genome}{Reference genome ('hg38' or 'mm10')}
}
\value{
A data.frame of the SCE features with their corresponding cytoband
name
}
\description{
Map the features of a SingleCellExperiment onto the cytobands
of a given genome. Some features might not be mapped to any cytobands (e.g.
if they are not in the canconical chromosomes), and are removed from the
returned object.
}
\details{
The cytobands are an arbitrary cutting of the genome that dates back to
staining metaphase chromosomes with Giemsa.
}
\examples{
data("scExp")
matching_cyto = get_cyto_features(scExp, ref_genome="hg38")
 
}
