% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_analysis_gene_set_enrichment.R
\name{differential_analysis_scExp}
\alias{differential_analysis_scExp}
\title{Runs differential analysis between cell clusters}
\usage{
differential_analysis_scExp(
  scExp,
  de_type = c("one_vs_rest_fast", "one_vs_rest", "pairwise", "custom")[1],
  by = "cell_cluster",
  method = "wilcox",
  block = NULL,
  group = NULL,
  ref = NULL,
  prioritize_genes = nrow(scExp) > 20000,
  max_distanceToTSS = 1000,
  progress = NULL,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{scExp}{A SingleCellExperiment object containing consclust with selected
number of cluster.}

\item{de_type}{Type of comparisons. Either 'one_vs_rest', to compare each
cluster against all others, or 'pairwise' to make 1 to 1 comparisons.
('one_vs_rest')}

\item{by}{= A character specifying the column of the object containing
the groups of cells to compare. Exclusive with de_type == custom}

\item{method}{Differential testing method, either 'wilcox' for Wilcoxon non-
parametric testing or 'neg.binomial' for edgerGLM based testing. ('wilcox')}

\item{block}{Use batches as blocking factors ? If TRUE, block will be taken
as the column "batch_id" from the SCE. Cells will be compared only within
samples belonging to the same batch.}

\item{group}{If de_type = "custom", the sample / cluster of interest as a
one- column data.frame. The name of the column is the group name and the
values are character either cluster ("C1", "C2", ...) or sample_id.}

\item{ref}{If de_type = "custom", the sample / cluster of reference as a one-
column data.frame. The name of the column is the group name and the values
are character either cluster ("C1", "C2", ...) or sample_id.}

\item{prioritize_genes}{First filter by loci being close to genes ? E.g. for
differential analysis, it is more relevant to keep features close to genes}

\item{max_distanceToTSS}{If prioritize_genes is TRUE, the maximum distance to
consider a feature close to a gene.}

\item{progress}{A shiny Progress instance to display progress bar.}

\item{BPPARAM}{BPPARAM object for multiprocessing. See
\link[BiocParallel]{bpparam} for more informations. Will take the default
BPPARAM set in your R session.}
}
\value{
Returns a SingleCellExperiment object containing a differential list.
}
\description{
Based on clusters of cell defined previously, runs non-parametric Wilcoxon
Rank Sum test to find significantly depleted or enriched features, in
'one_vs_rest' mode or 'pairwise' mode. In pairwise mode, each cluster is
compared to all other cluster individually, and then pairwise comparisons
between clusters are combined to find overall differential features using
combineMarkers function from scran.
}
\details{
This functions takes as input a SingleCellExperiment object with consclust,
the type of comparison, either 'one_vs_rest' or 'pairwise', the adjusted
p-value threshold (qval.th) and the fold-change threshold (logFC.th). It
outputs a SingleCellExperiment object containing a differential list.
}
\examples{
data("scExp")
scExp_cf = differential_analysis_scExp(scExp)

}
