% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagMatrix.R
\name{getBioRegion}
\alias{getBioRegion}
\title{getBioRegion}
\usage{
getBioRegion(
  TxDb = NULL,
  upstream = 1000,
  downstream = 1000,
  by = "gene",
  type = "start_site"
)
}
\arguments{
\item{TxDb}{TxDb}

\item{upstream}{upstream from start site or end site}

\item{downstream}{downstream from start site or end site}

\item{by}{one of 'gene', 'transcript', 'exon', 'intron' , '3UTR' , '5UTR', 'UTR'}

\item{type}{one of "start_site", "end_site", "body"}
}
\value{
GRanges object
}
\description{
prepare a bioregion of selected feature
}
\details{
this function combined previous functions getPromoters(), getBioRegion() and getGeneBody() in order
to solve the following issues.

(1) \url{https://github.com/GuangchuangYu/ChIPseeker/issues/16}

(2) \url{https://github.com/GuangchuangYu/ChIPseeker/issues/87}

The getBioRegion() function can prevoid a region of interest from
\code{txdb} object. There are three kinds of regions, \code{start_site},
\code{end_site} and \code{body}. 

We take transcript region to expain the differences of these three regions.
tx: chr1 1000 1400. 

\code{body} region refers to the 1000-1400bp.

\code{start_site} region with \code{upstream = 100, downstream = 100} refers to 900-1100bp. 

\code{end_site} region with \code{upstream = 100, downstream = 100} refers to 1300-1500bp.
}
\author{
Guangchuang Yu, Ming L
}
