% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countPatternInSeqs.R
\name{countPatternInSeqs}
\alias{countPatternInSeqs}
\title{Output total number of patterns found in the input sequences}
\usage{
countPatternInSeqs(pattern, sequences)
}
\arguments{
\item{pattern}{DNAstringSet object}

\item{sequences}{a vector of sequences}
}
\value{
Total number of occurrence of the pattern in the sequences
}
\description{
Output total number of patterns found in the input sequences
}
\examples{
  library(Biostrings)
  filepath = 
    system.file("extdata", "examplePattern.fa", package="ChIPpeakAnno")
  dict = readDNAStringSet(filepath = filepath, format="fasta", 
                          use.names=TRUE)
  sequences = c("ACTGGGGGGGGCCTGGGCCCCCAAAT", 
                "AAAAAACCCCTTTTGGCCATCCCGGGACGGGCCCAT", 
                "ATCGAAAATTTCC")
  countPatternInSeqs(pattern=dict[1], sequences=sequences)
  countPatternInSeqs(pattern=dict[2], sequences=sequences)
  pattern = DNAStringSet("ATNGMAA")
  countPatternInSeqs(pattern=pattern, sequences=sequences)

}
\seealso{
summarizePatternInPeaks, translatePattern
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
