% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{RunGroupGSEA}
\alias{RunGroupGSEA}
\alias{RunGroupGSEA.Seurat}
\alias{RunGroupGSEA.SingleCellExperiment}
\title{Run GSEA on cluster/groups}
\usage{
RunGroupGSEA(
  X,
  pathways,
  group.by,
  reduction,
  dims,
  features,
  nperm,
  minSize,
  maxSize,
  gseaParam
)

\method{RunGroupGSEA}{Seurat}(
  X,
  pathways,
  group.by = NULL,
  reduction = "mca",
  dims = seq(50),
  features = NULL,
  nperm = 1000,
  minSize = 10,
  maxSize = 500,
  gseaParam = 0
)

\method{RunGroupGSEA}{SingleCellExperiment}(
  X,
  pathways,
  group.by,
  reduction = "MCA",
  dims = seq(50),
  features = NULL,
  nperm = 1000,
  minSize = 10,
  maxSize = 500,
  gseaParam = 0
)
}
\arguments{
\item{X}{pathways List of gene sets to check}

\item{pathways}{reduction Which dimensionality reduction to use, must be based on MCA.}

\item{group.by}{dims A vector of integers indicating which dimensions to use with reduction embeddings and loadings for distance calculation.}

\item{reduction}{features Character vector of feature names to subset feature coordinates. If not specified will take all features available from specified reduction Loadings.}

\item{dims}{cells Character vector of cell names to subset cell coordinates. If not specified will take all features available from specified reduction Embeddings}

\item{features}{cells Character vector of cell names to subset cell coordinates. If not specified will take all features available from specified reduction Embeddings}

\item{nperm}{nperm Number of permutations to do. Minimial possible nominal p-value is about 1/nperm}

\item{minSize}{minSize Minimal size of a gene set to test. All pathways below the threshold are excluded.}

\item{maxSize}{maxSize Maximal size of a gene set to test. All pathways above the threshold are excluded.}

\item{gseaParam}{gseaParam GSEA parameter value, all gene-level statis are raised to the power of 'gseaParam' before calculation of GSEA enrichment scores}
}
\value{
A data.table with geneset enrichment analysis statistics.
}
\description{
Calculate group gene specificty ranking and then perform geneset enrichment analysis on it.
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
GSEAResults <- RunGroupGSEA(seuratPbmc, Hallmark, group.by = "seurat_clusters", dims = 1:5)
}
