% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadExperimentalData.r
\name{ReadExperimentalData}
\alias{ReadExperimentalData}
\title{read experimental data}
\usage{
ReadExperimentalData(fileName, network, removeDuplicates)
}
\arguments{
\item{fileName}{a file containing the experimental data (text file format)}

\item{network}{a (Computational) Causal Graph, as an igraph.}

\item{removeDuplicates}{Optional, defaults to true. Remove duplicated nodes the experimental file (i.e. where the result for a node is repeated, use the first value given only; the alternative is to return a result which contains multiple rows for this node).}
}
\value{
(n x 2) matrix of nodes and direction of regulation. The first column of the matrix contains the node IDs from the network, and the second contains the experimental values.
}
\description{
Reads experimental data for the causal reasoning algorithm from a text file.
}
\examples{
#get path to example network file
network <- system.file(package='CausalR', 'extdata', 'testNetwork.sif')
##create ccg
ccg <- CreateCCG(network)
#get path to example experimental data
fileName<- system.file(package='CausalR', 'extdata', 'testData.txt')
ReadExperimentalData(fileName, ccg)
}
\concept{
CausalR
}

