% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindApproximateValuesThatWillMaximiseDValue.r
\name{FindApproximateValuesThatWillMaximiseDValue}
\alias{FindApproximateValuesThatWillMaximiseDValue}
\title{find approximate values that will maximise D value}
\usage{
FindApproximateValuesThatWillMaximiseDValue(predictionListStats,
  experimentalDataStats)
}
\arguments{
\item{predictionListStats}{a vector containing the values q+, q- and q0: 
numbers of positive, negative and non-significant/contradictory predictions}

\item{experimentalDataStats}{a vector containing the values n+, n- and n0:
numbers of positive, negative and non-significant/contradictory predictions}
}
\value{
a 2x2 contingency table which approximately maximises D
}
\description{
Finds an approximate table values to maximise D.
Given the values of q+, q-, q0, n+, n- and n0 this function will produce the approximate values
of n++, n+-, n-+ and n-- that will maximise the D value. See Assessing statistical significance of 
casual graphs, page 6. The values are approximate since they need to be rounded, although the direction
of rounding is not clear at this stage.
}
\references{
L Chindelevitch et al.
Assessing statistical significance in causal graphs.
BMC Bioinformatics, 13(35), 2012.
}

