% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateSignificanceUsingCubicAlgorithm1b.r
\name{CalculateSignificanceUsingCubicAlgorithm1b}
\alias{CalculateSignificanceUsingCubicAlgorithm1b}
\title{Calculate Significance Using Cubic Algorithm}
\usage{
CalculateSignificanceUsingCubicAlgorithm1b(hypothesisScore, predictionListStats,
  experimentalDataStats, epsilon)
}
\arguments{
\item{hypothesisScore}{The score whose p-value we want to find.}

\item{predictionListStats}{Number of predicted up-regulated, 
predicted down-regulated and ambiguous predictions.}

\item{experimentalDataStats}{Number of up-regulated, down-regulated and not 
significantly changed transcripts in the experimental data.}

\item{epsilon}{The threshold that is used when calculating the p-value 
using the cubic algorithm. (Defaults to 1e-5, only used for the cubic 
algorithm, ignored if useCubicAlgorithm is FALSE.)}
}
\value{
p value
}
\description{
Calculate the p-value of a score given the hypothesis score and the distribution table (calculated using the cubic algorithm  1b in Assessing statistical significance in causal graphs - Chindelevitch et al)
}
\examples{
CalculateSignificance(5, c(7,4,19), c(6,6,18))
CalculateSignificance(5, c(7,4,19), c(6,6,18), useCubicAlgorithm=TRUE)
CalculateSignificanceUsingQuarticAlgorithm(5, c(7,4,19), c(6,6,18))
CalculateSignificance(5, c(7,4,19), c(6,6,18), useCubicAlgorithm=FALSE)
CalculateSignificance(5, c(7,4,19), c(6,6,18), 1e-5)
CalculateSignificance(5, c(7,4,19), c(6,6,18), epsilon=1e-5, useCubicAlgorithm=TRUE)
CalculateSignificanceUsingCubicAlgorithm1b(5, c(7,4,19), c(6,6,18), 1e-5)
}
\concept{
CausalR
}

