% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeneAnnotation.R
\name{annotateGeneAsVector}
\alias{annotateGeneAsVector}
\title{This function returns a numeric indicating which gene
sets it does and does not belong to.  This vector can
be normalised to account for the sizes of the sets.}
\usage{
annotateGeneAsVector(gene, geneSets, normalise = FALSE)
}
\arguments{
\item{gene}{\itemize{
\item the gene to annotate
}}

\item{geneSets}{\itemize{
\item a list of gene sets
}}

\item{normalise}{\itemize{
\item whether to normalise by set size
}}
}
\value{
a numeric
}
\description{
This function returns a numeric indicating which gene
sets it does and does not belong to.  This vector can
be normalised to account for the sizes of the sets.
}
\examples{
hallmark = make.getExample()('hallmark')
Myc = annotateGeneAsVector('Myc',hallmark)
MycNormalised = annotateGeneAsVector('Myc',hallmark,TRUE)
}
