% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_data_preprocessing.R
\name{readDataTable}
\alias{readDataTable}
\title{Read data in different table input formats (xlsx, csv or txt).
Extracts the two relevant columns (concentration and measurement) and
orders the data by increasing concentration.}
\usage{
readDataTable(
  dataPath,
  fileType,
  concCol,
  measCol,
  sep = ",",
  dec = ".",
  header = TRUE,
  naStrings = c("NA", "NaN", "Filtered", "#NV"),
  sheet = 1
)
}
\arguments{
\item{dataPath}{\strong{character(1)} \cr Path to the data file
(.csv, .txt or .xlsx file).}

\item{fileType}{\strong{character(1)} \cr Type of file: "csv", "txt" or "xlsx".}

\item{concCol}{\strong{integer(1)} \cr Column number of the concentration values.}

\item{measCol}{\strong{integer} \cr Column number of the concentration values.}

\item{sep}{\strong{character(1)} \cr The field separator, default is ",".}

\item{dec}{\strong{character(1)} \cr Decimal separator, default is ".".}

\item{header}{\strong{logical(1)} \cr If TRUE, first line is counted as column
names. The default is TRUE.}

\item{naStrings}{\strong{character} \cr Vector of strings which are to be
interpreted as NA. The default is c("NA", "NaN", "Filtered", "#NV").}

\item{sheet}{\strong{integer(1)} \cr Sheet number (only needed for xlsx files,
default is to use the first sheet).}
}
\value{
Data.frame with two numeric columns: Concentration and Measurement
}
\description{
Read data in different table input formats (xlsx, csv or txt).
Extracts the two relevant columns (concentration and measurement) and
orders the data by increasing concentration.
}
\examples{
### xlsx file:
file <- system.file("extdata", "MSQC1_xlsx", "GGPFSDSYR_QTRAP_y5.xlsx",
    package = "CalibraCurve"
)
D <- readDataTable(file, fileType = "xlsx", concCol = 16, measCol = 12)

}
