% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_response_factors.R
\name{calcRF}
\alias{calcRF}
\title{Calculate Response factors}
\usage{
calcRF(x, mod)
}
\arguments{
\item{x}{\strong{list of data.frames} \cr List of data.frames containing data for
each concentration level (result from \code{\link{cleanData}}).}

\item{mod}{\strong{lm object} \cr Final linear model fit (object "mod" from
results of \code{\link{calculate_FLR}}).}
}
\value{
List with the following elements:
\itemize{
\item \code{RFs}: List with response factors for each concentration level.
\item \code{meanRFs}: Vector with mean response factors for each concentration
level.
}

response factor values for each concentration level.
}
\description{
Final linear range: Function, which returns a list with response factor
values for a data set (given as list)
}
\examples{
file <- system.file("extdata", "MSQC1", "msqc1_dil_GGPFSDSYR.rds",
package = "CalibraCurve")
D_list <- readDataSE(file, concColName = "amount_fmol",
        substColName = "Substance", assayNumber = 1)
data_cleaned <- cleanData(D_list[[1]])
RES_PLR <- calculate_PLR(data_cleaned, calcContinuousPrelimRanges = FALSE)
RES_FLR <- calculate_FLR(RES_PLR$dataPrelim)

calcRF(data_cleaned, mod = RES_FLR$mod)
}
