% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterType.R
\name{mutFilterType}
\alias{mutFilterType}
\title{mutFilterType}
\usage{
mutFilterType(maf, keepType = "exonic")
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{keepType}{A group of variant classifications will be kept,
including 'exonic', 'nonsynonymous' and 'all'. Default: 'exonic'.}
}
\value{
An MAF data frame where some variants
has T tag in CaTag column for variant type filtration
}
\description{
Filter variants based on variant types
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterType(maf)
}
