% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterNormalDP.R
\name{mutFilterNormalDP}
\alias{mutFilterNormalDP}
\title{mutFilterNormalDP}
\usage{
mutFilterNormalDP(maf, dbsnpCutoff = 19, nonCutoff = 8, verbose = TRUE)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{dbsnpCutoff}{Cutoff of normal depth for dbSNP variants. Default: 19.}

\item{nonCutoff}{Cutoff of normal depth for non-dbSNP variants. Default: 8.}

\item{verbose}{Whether to generate message/notification during the 
filtration process. Default: TRUE.}
}
\value{
An MAF data frame where some variants
has N tag in CaTag column for Normal depth filtration.
}
\description{
Filter dbsnp/non-dbsnp variants based on their normal depth.
Variants in dbSNP database should have normal depth >= 19, while non-dbSNP
variants should have normal depth >= 8 to avoid being filtered.
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterNormalDP(maf)
}
