% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterCom.R
\name{mutFilterCom}
\alias{mutFilterCom}
\title{mutFilterCom}
\usage{
mutFilterCom(
  maf,
  PONfile = NULL,
  PONformat = "vcf",
  panel = "Customized",
  tumorDP = 20,
  normalDP = 10,
  tumorAD = 5,
  normalAD = Inf,
  VAF = 0.05,
  VAFratio = 0,
  dbsnpCutoff = 19,
  nonCutoff = 8,
  SBmethod = "SOR",
  SBscore = 3,
  maxIndelLen = 50,
  minInterval = 10,
  tagFILTER = "PASS",
  dbVAF = 0.01,
  ExAC = TRUE,
  Genomesprojects1000 = TRUE,
  gnomAD = TRUE,
  dbSNP = FALSE,
  keepCOSMIC = TRUE,
  keepType = "exonic",
  bedFile = NULL,
  bedHeader = FALSE,
  bedFilter = FALSE,
  mutFilter = FALSE,
  ESP6500 = TRUE,
  selectCols = TRUE,
  report = TRUE,
  assay = "MSK-v3",
  genelist = NULL,
  mutType = "nonsynonymous",
  reportFile = "FilterReport.html",
  reportDir = "./",
  TMB = TRUE,
  cancerType = NULL,
  reference = NULL,
  progressbar = TRUE,
  codelog = FALSE,
  codelogFile = "mutFilterCom.log",
  verbose = TRUE
)
}
\arguments{
\item{maf}{An MAF data frame.}

\item{PONfile}{Panel-of-Normals files, which can be either obtained through 
GATK (https://gatk.broadinstitute.org/hc/en-us/articles/360035890631-Panel-of-Normals-PON-)
or generated by users. Should have at least four columns: CHROM, POS, REF, ALT
Defalut: NULL.}

\item{PONformat}{The format of PON file, either "vcf" or "txt". Default: "vcf"}

\item{panel}{The sequencing panel applied on the dataset. Parameters
for \code{\link{mutFilterQual}} function are set differently for different
panels. Default: "Customized". Options: "MSKCC", "WES".}

\item{tumorDP}{Threshold of tumor total depth. Default: 20}

\item{normalDP}{Threshold of normal total depth. Default: 10}

\item{tumorAD}{Threshold of tumor alternative allele depth. Default: 5}

\item{normalAD}{Threshold of normal alternative allele depth. Default: Inf}

\item{VAF}{Threshold of VAF value. Default: 0.05}

\item{VAFratio}{Threshold of VAF ratio (tVAF/nVAF). Default: 0.}

\item{dbsnpCutoff}{Cutoff of normal depth for dbSNP variants. Default: 19.}

\item{nonCutoff}{Cutoff of normal depth for non-dbSNP variants. Default: 8.}

\item{SBmethod}{Method will be used to detect strand bias,
including 'SOR' and 'Fisher'. Default: 'SOR'. SOR: StrandOddsRatio
(https://gatk.broadinstitute.org/hc/en-us/articles/360041849111-
StrandOddsRatio)}

\item{SBscore}{Cutoff strand bias score used to filter variants.
Default: 3.}

\item{maxIndelLen}{Maximum length of indel accepted to be included.
Default: 50.}

\item{minInterval}{Maximum length of interval between an SNV and an indel
accepted to be included. Default: 10.}

\item{tagFILTER}{Variants with spcific tag in the FILTER column will be kept,
Default: 'PASS'.}

\item{dbVAF}{Threshold of VAF value for databases. Default: 0.01.}

\item{ExAC}{Whether to filter variants listed in ExAC with VAF higher than
cutoff(set in VAF parameter). Default: TRUE.}

\item{Genomesprojects1000}{Whether to filter variants listed in
Genomesprojects1000 with VAF higher than cutoff(set in VAF parameter).
Default: TRUE.}

\item{gnomAD}{Whether to filter variants listed in gnomAD with VAF higher
than cutoff(set in VAF parameter). Default: TRUE.}

\item{dbSNP}{Whether to filter variants listed in dbSNP. Default: FALSE.}

\item{keepCOSMIC}{Whether to keep variants in COSMIC even
they have are present in germline database. Default: TRUE.}

\item{keepType}{A group of variant classifications will be kept,
including 'exonic', 'nonsynonymous' and 'all'. Default: 'exonic'.}

\item{bedFile}{A file in bed format that contains region information.
Default: NULL.}

\item{bedHeader}{Whether the input bed file has a header or not. 
Default: FALSE.}

\item{bedFilter}{Whether to filter the information in bed file or not, which
only leaves segments in Chr1-Ch22, ChrX and ChrY. Default: FALSE.}

\item{mutFilter}{Whether to directly return a filtered MAF data frame.
If FALSE, a simulation filtration process will be run, and the original MAF
data frame with tags in CaTag column, and  a filter report will be returned.
If TRUE, a filtered MAF data frame and a filter report will be generated.
Default: FALSE.}

\item{ESP6500}{Whether to filter variants listed in ESP6500 with VAF higher
than cutoff(set in VAF parameter). Default: TRUE.}

\item{selectCols}{Columns will be contained in the filtered data frame.
By default (TRUE), the first 13 columns and 'Tumor_Sample_Barcode' column.
Or a vector contains column names will be kept.}

\item{report}{Whether to generate report automatically. Default: TRUE}

\item{assay}{Methodology and assay will be applied as a reference, including
'MSK-v3', 'MSK-v2', 'MSK-v1', 'FoundationOne', 'Pan-Cancer Panel' and
'Customized'. Default: 'MSK-v3'.}

\item{genelist}{A vector of panel gene list, only useful when assay is set to
'Customized'.}

\item{mutType}{A group of variant classifications that will be kept in TMB
calculation, only useful when assay is set to 'Pan-Cancer Panel' or 'Customized',
including 'exonic' and 'nonsynonymous'. Default: 'nonsynonymous'.}

\item{reportFile}{File name of the report. Default: 'FilterReport.html'}

\item{reportDir}{Path to the output report file. Default: './'.}

\item{TMB}{Whether to calculate TMB. Default: TRUE. Note: CaMutQC uses 
unfiltered maf to calculate TMB value.}

\item{cancerType}{Type of cancer whose filtering parameters
need to be referred to.  Options are: "COADREAD", "BRCA", "LIHC", "LAML",
"LCML", "UCEC", "UCS", "BLCA", "KIRC" and "KIRP"}

\item{reference}{A specific study whose filtering strategies
need to be referred to.
Format: "Last_name_of_the_first_author_et_al-Journal-Year-Cancer_type"
Options are: "Haraldsdottir_et_al-Gastroenterology-2014-UCEC",
"Cherniack_et_al-Cancer_Cell-2017-UCS",
"Mason_et_al-Leukemia-2015-LCML",
"Gerlinger_et_al-Engl_J_Med-2012-KIRC"
"Zhu_et_al-Nat_Commun-2020-KIRP"}

\item{progressbar}{Whether to show progress bar when running this function
Default: TRUE}

\item{codelog}{If TRUE, your code, along with the parameters you set, 
will be export in a log file. It will be convenient for users to repeat 
experiments. Default: FALSE}

\item{codelogFile}{Where to store the codelog, only useful when codelog is
set to TRUE. Default: "mutFilterCom.log"}

\item{verbose}{Whether to generate message/notification during the 
filtration process. Default: TRUE.}
}
\value{
An MAF data frame after common strategy filtration

A filter report in HTML format
}
\description{
Apply common filtering strategies on a MAF data frame.
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterCom(maf,
PONfile=system.file("extdata", "PON_test.txt", package="CaMutQC"),
TMB=FALSE, report=FALSE, PONformat="txt", verbose=FALSE)
}
