% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPA_cell_type_expression.R
\name{HPA_cell_type_expression}
\alias{HPA_cell_type_expression}
\title{Gene expression in different human cell types}
\usage{
HPA_cell_type_expression(
  genes = NULL,
  units = c("scaled", "TPM", "log_TPM"),
  include_CTP = FALSE,
  scale_lims = NULL,
  values_only = FALSE
)
}
\arguments{
\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{units}{\code{character(1)} with expression values unit.  Can be
\code{"TPM"}, \code{"log_TPM"} (log(TPM + 1)) or \code{"scaled"} (scaled TPM
values). Default is \code{"scaled"}.}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{scale_lims}{\verb{vector of length 2} setting the lower and upper limits
of the heatmap colorbar.}

\item{values_only}{\code{logical(1)}. If \code{TRUE}, the function will return the
SummarizedExperiment instead of the heatmap. Default is \code{FALSE}.}
}
\value{
A heatmap of selected CT genes expression in
different human cell types.
If \code{values_only = TRUE}, a SummarizedExperiment instead of the heatmap
is returned instead.
}
\description{
Plots a heatmap of genes expression in the different human cell types based
on scRNAseq data obtained from the Human Protein Atlas
(https://www.proteinatlas.org)
}
\examples{

HPA_cell_type_expression(
    genes = NULL, units = "scaled", scale_lims = NULL,
    values_only = FALSE)
HPA_cell_type_expression(
    genes = c("MAGEA1", "MAGEA3", "MAGEA4"),
    units = "TPM", scale_lims = c(0, 50),
    values_only = FALSE)
}
