% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{scRNAseq_HPA}
\alias{scRNAseq_HPA}
\title{Gene expression in human cell types}
\format{
A \code{SingleCellExperiment} object with 20082 rows and 66 columns
\itemize{
\item Rows correspond to genes (ensembl gene id as rownames)
\item Columns correspond to cell types
\item Expression values correspond to transcripts per million protein coding genes
(pTPM)
}
}
\source{
Gene expression values in cell types, based on multiple scRNAseq datasets
obtained from the Human Protein Atlas
(https://www.proteinatlas.org/about/download)
The data were converted in a SummarizedExperiment
(see \verb{scripts/14_make_scRNAseq_HPA.R} for details).
}
\description{
Gene expression profiles in different human cell types based on scRNAseq data
obtained from the Human Protein Atlas (https://www.proteinatlas.org)
}
\details{
Description of the colData:
\itemize{
\item Column \code{Cell_type} gives cell type.
\item Column \code{group} gives the cell type group (defined in the Human Protein Atlas).
}

Description of the rowData:
\itemize{
\item Column \code{max_TPM_in_a_somatic_cell_type} gives the maximum expression value
found in a somatic cell type
\item Column \code{max_in_germcells_group} gives the maximum expression value found
in a germ cell type
\item Column \code{Higher_in_somatic_cell_type} specifies if a somatic cell type
}
}
