% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_ctd.R
\name{download_ctd_genes}
\alias{download_ctd_genes}
\title{Function to download genes available in CTDbase}
\usage{
download_ctd_genes(verbose = FALSE, ask = TRUE)
}
\arguments{
\item{verbose}{(default \code{FALSE}) If set to \code{TRUE} is shows relevant
information of each step.}

\item{ask}{(default \code{TRUE}) If \code{TRUE} it asks the the persistent
location must be used.}
}
\value{
Passed name into \code{filename} argument if it could be download
\code{1} otherwise.
}
\description{
This function download the "Gene vocabulary" file (\code{CTD_genes.tsv.gz})
from \code{http://ctdbase.org/downloads}.
}
\details{
The field included in the file (\code{CTD_genes.tsv.gz}) are:
\enumerate{
 \item GeneSymbol
 \item GeneName
 \item GeneID (NCBI Gene identifier)
 \item AltGeneIDs (alternative NCBI Gene identifiers; '|'-delimited list)
 \item Synonyms ('|'-delimited list)
 \item BioGRIDIDs ('|'-delimited list)
 \item PharmGKBIDs ('|'-delimited list)
 \item UniprotIDs ('|'-delimited list)
}
}
\examples{
download_ctd_genes()
}
