% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRegionCounts.R
\name{getRegionCounts}
\alias{getRegionCounts}
\title{Quantify region level count data}
\usage{
getRegionCounts(
  regionBed,
  sampleInfo,
  sampleDir = ".",
  backgroundSubtract = TRUE,
  ...
)
}
\arguments{
\item{regionBed}{A bed file containing the list of regions that are being 
analyzed.}

\item{sampleInfo}{Object from \code{\link{preprocessData}} containing 
sample information.}

\item{sampleDir}{Location of the input sample files in `sampleInfo` file.
(default: ".")}

\item{backgroundSubtract}{Logical indicating if background correction 
should be performed. (default: TRUE)}

\item{...}{Additional arguments passed on to \code{\link{getBgSubVal}}.}
}
\value{
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}} 
containing the regions, 
   sample information and counts for all samples.
}
\description{
The input is the set of regions and the sample information. It will 
calculate the number of reads falling in each region for each sample.
Returns a 
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}} 
object with regions, sample informationa and counts for all samples.
}
\examples{
sampleInfo <- read.table(system.file("extdata", "sample_info.txt", 
package="CSSQ",mustWork = TRUE),sep="\\t",header=TRUE)
countData <- getRegionCounts(system.file("extdata", "chr19_regions.bed", 
package="CSSQ"),sampleInfo,
sampleDir = system.file("extdata", package="CSSQ"))
countData
head(assays(countData)$countData)
colData(countData)
rowRanges(countData)
}
\seealso{
\code{\link{getBgSubVal}} which this function calls.
}
