% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_modules.R, R/generics.R
\name{edgeLists.default}
\alias{edgeLists.default}
\alias{edgeLists.data.frame}
\alias{edgeLists.list}
\alias{edgeLists}
\title{Extract the edge list from overlap data frame or list of overlap
data frames}
\usage{
\method{edgeLists}{default}(overlapObj, ...)

\method{edgeLists}{data.frame}(overlapObj, ...)

\method{edgeLists}{list}(overlapObj, groupNames, cutoff = NULL, ...)

edgeLists(overlapObj, ...)
}
\arguments{
\item{overlapObj}{An overlap data frame or list of overlap data frames.}

\item{...}{Additional arguments.}

\item{groupNames}{Names of groups. If provided, must be a vector
of the same length as the list of overlap data frames.}

\item{cutoff}{Number of retained edges from each overlap data frame after
refiltering. If \code{NULL} (as default), no refiltering will be performed.}
}
\value{
A list of data frames.
}
\description{
This function creates a list of data frames with three columns:
gene1, gene2 and group. If \code{overlapObj} is an overlap data frame,
the groups correspond to the connected components. If it is a
list of overlap data frames, the groups must be specified as
groupNames.
}
\keyword{internal}
