% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_test_normalization_f.R
\name{train_test_normalization_f}
\alias{train_test_normalization_f}
\title{Train-Test Data Normalization Function}
\usage{
train_test_normalization_f(train_data, test_data, col_num)
}
\arguments{
\item{train_data}{A data frame containing the training dataset. The first
columns represent clinical data, and the rest represent gene expression
data.}

\item{test_data}{A data frame containing the test dataset. The structure
is the same as \code{train_data}.}

\item{col_num}{An integer specifying the starting column index of the gene
expression data in the datasets.}
}
\value{
A list containing four data frames:
\describe{
\item{Train_Clin}{A data frame containing the clinical data from the
training dataset.}
\item{Test_Clin}{A data frame containing the clinical data from the
test dataset.}
\item{Train_Norm_data}{A data frame containing the combined clinical
and normalized gene expression data for the training set.}
\item{Test_Norm_data}{A data frame containing the combined clinical
and normalized gene expression data for the test set.}
}
}
\description{
This function performs normalization on training and test datasets, which
include clinical data and gene expression values.
The function applies log transformation and quantile normalization to the
gene expression values.
}
\details{
The function performs the following steps:
\enumerate{
\item Splits clinical and gene expression data based on \code{col_num}.
\item Applies log2 transformation to the gene expression data.
\item Performs quantile normalization on the log-transformed data
for both training and test datasets.
\item Combines the clinical data with the normalized gene expression
data.
}
}
\examples{
# Example datasets
train_data <- data.frame(matrix(rnorm(100), nrow = 10))
test_data <- data.frame(matrix(rnorm(100), nrow = 10))
col_num <- 5
result <- train_test_normalization_f(train_data, test_data, col_num)
str(result$Train_Norm_data)
str(result$Test_Norm_data)

}
