% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_NBE.R
\name{Fluo_ordering}
\alias{Fluo_ordering}
\title{Fluo_ordering}
\usage{
Fluo_ordering(data, den.method = "wavelets", savePlot = "OFF")
}
\arguments{
\item{data}{List. The outut of Fluo_modeling().}

\item{den.method}{Character string. A method to denoise the transformed channel signal differences (used for change-point analysis).
The denoising obtains the residuals that can be subjected to statistical testing (model assumptions). It is one of
"splines", "wavelets" or "lregr" (linear regression). Default is "wavelets".}

\item{savePlot}{Character string. Directory to store the plots. Its value can be an existing directory
or "screen" that prints the plot only on the screen or "OFF" that does not generate a plot (suggested
only during cross-validations). Default is the current working directory, getwd().}
}
\value{
The list of final results in two components:
  Summary_results:
    It contains a matrix that summarizes the findings of CONFESS. It has the index number of each sample, the sample IDs, the run IDs,
    the estimated cell size, the estimated run corrected cell size, the estimated pseudotime, the log, and if specified, DDHFmv transformed
    channel signals, the log or DDHFmv transformed channel differences, the estimated clusters, the residuals and a column flagginf outlier samples.

  Analytical results:
    It contains all the components of Fluo_modeling() with the addition of:
    Outliers: a vector having "normal" for non-outlier samples and "outlier" for outlier samples. The outliers are estimated by Grubbs
      statistic based on their distance from the bulk of the clustered samples.
    Residuals: the residuals of the fitted model for the denoising of the corrected transformed channel differences (see parameter den.method).
    Residuals_diagnostics: various normality tests for the estimated residuals.

  The component of
}
\description{
It produces the final output table of CONFESS. It includes the Sample IDs, the Run IDs, the estimated cell areas
  (image analysis), the corrected fluorescence signals of both channels (run and background adjustED), the
  pseudotimes of cell progression, the final cell clusters and other statistics of cell progression analysis.
}
\examples{
step5<-Fluo_ordering(data=step4,savePlot="OFF")
}
