% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Response.R
\name{Response}
\alias{Response}
\alias{Response.COMPASSResult}
\title{Compute a response probability from COMPASS mcmc samples.}
\usage{
Response(x, markers, degree, max.prob, at_least_n)

\method{Response}{COMPASSResult}(x, markers = NULL, degree = 1, max.prob = FALSE, at_least_n = NULL)
}
\arguments{
\item{x}{a \code{COMPASSResult} object.}

\item{markers}{a \code{vector} of marker names.}

\item{degree}{the \code{numeric} degree of functionality to test.}

\item{max.prob}{\code{logical} Use the max probability rather than the average across subsets. Defaults to FALSE.}

\item{at_least_n}{\code{logical} response of degree x or greater with at_least_n subsets responding.}
}
\value{
A \code{vector} of response probabilities for each subject.
}
\description{
Compute a response probability based on the selected markers, evaluating the probability
that a subject exhibits a response of size \code{degree} or greater.
i.e., the probability of at least \code{degree} markers exhibiting an antigen specific response.
}
\details{
The response is computed from the sampled Gamma matrix, subsetting on the selected markers, and
}
\examples{

Response(CR, markers = c("M1","M2","M3"), degree = 2)
}
