\name{downloadPathways}
\alias{downloadPathways}
\title{Download KEGG pathways in KGML format.}
\usage{
downloadPathways(org, pathways)
}
\arguments{
\item{org}{KEGG organism identifier}

\item{pathways}{Download pathways for specified organism: 
\tabular{rrl}{
    \tab 'All' \tab  All organism pathways\cr
    \tab 'Metabolic' \tab  Metabolic pathways\cr
    \tab 'Non-Metabolic' \tab  Non metabolic pathways\cr
    \tab <vector of indexes> \tab  Using indexes from 
    \code{\link{downloadKEGGPathwayList}}\cr
    \tab <vector of names> \tab  Using pathway identifiers 
    (i.e. c('00010', '00020'))
}}
}
\value{
Downloaded data is stored in CHRONOS/extdata/Downloads/KEGG/<org>
}
\description{
Download KEGG pathways in KGML format.
}
\details{
KEGG (Kyoto Encyclopedia of Genes and Genomes) is a database resource 
for understanding high-level functions and utilities of the biological ,
system such as the cell, the organism and the ecosystem, from 
molecular-level information, especially large-scale molecular datasets 
generated by genome sequencing and other high-throughput experimental 
technologies. \cr

Files are downloaded in CHRONOS/extdata/Downloads/KEGG/<org> folder. \cr
Downloading is skipped for existing files. \cr

}
\examples{

# View all availiable hsa pathways
\dontrun{pathways <- downloadKEGGPathwayList(org='hsa')}

# Download pathway KGML files
pathways <- c('04915', '04917', '04930', '05031')

\dontrun{pathways <- downloadPathways(org='hsa', pathways=pathways)}

}
\references{
\itemize{
    \item{\url{http://www.genome.jp/kegg/pathway.html}}
}
}

