# Be careful of the quantities log(xxx) below. The smallest possible value is -1.
# Map the interval [-1, MINLOGARG) to [LARGENEGVAL, LOGMINLOGARG)
mylog <- function(x) {

  MINLOGARG    <- 1e-100
  LOGMINLOGARG <- -230.25850929940457945
  LARGENEGVAL  <- -1e100

  if (x < MINLOGARG) {
    ret <- LARGENEGVAL + ((LOGMINLOGARG-LARGENEGVAL)/(MINLOGARG + 1))*(x + 1)
  } else {
    ret <- log(x)
  }

  ret

} # END: mylog

# For a vector x. Let MINLOGARG be the smallest value
mylog2 <- function(x) {

  MINLOGARG <- 1e-100

  x[(x < MINLOGARG)] <- MINLOGARG
  log(x)

} # END: mylog2


 logLikBinom.add.reparam.general.trend<-function(theta,x1.cols,x2.cols,datX.all,covs,y,method2){    # this optimize covariates too

      cov.prod=0

      g20= mylog( 2.0*exp(theta[x1.cols[1]])-1)
      g21 = mylog(2.0*exp(theta[x1.cols[1]]+theta[x2.cols[1]]-theta[x2.cols[2]])-exp(theta[x2.cols[1]])) - g20 -theta[x2.cols[1]]
      if(is.null(covs)==FALSE) cov.prod = covs %*% theta[-c(1,x1.cols,x2.cols)]
      Ps=logit( theta[1] +  datX.all%*% c(theta[x1.cols],g20,theta[x2.cols],g21) + cov.prod  )
      -2*sum(y*mylog2(Ps) + (1-y)*mylog2(1-Ps))


 }# end of
