% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{show_plot}
\alias{show_plot}
\alias{show_plot,CEMiTool-method}
\title{Retrieve CEMiTool object plots}
\usage{
show_plot(cem, value)

\S4method{show_plot}{CEMiTool}(
  cem,
  value = c("profile", "gsea", "ora", "interaction", "beta_r2", "mean_k", "sample_tree",
    "mean_var", "hist", "qq")
)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{value}{A character string containing the name of the plot to be shown.
One of "profile", "gsea", "ora", "interaction", "beta_r2", "mean_k", "sample_tree",
"mean_var", "hist", "qq".}
}
\value{
A plot corresponding to a CEMiTool analysis
}
\description{
Retrieve CEMiTool object plots
}
\examples{
# Get example CEMiTool object
data(cem)
# Plot beta x R squared graph
cem <- plot_beta_r2(cem)
# Check plot
show_plot(cem, "beta_r2")
}
