% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_interactions}
\alias{plot_interactions}
\alias{plot_interactions,CEMiTool-method}
\title{Network visualization}
\usage{
plot_interactions(cem, ...)

\S4method{plot_interactions}{CEMiTool}(cem, n = 10, ...)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{n}{number of nodes to label}
}
\value{
Object of class \code{CEMiTool} with profile plots
}
\description{
Creates a graph based on interactions provided
}
\examples{
# Get example CEMiTool object
data(cem)
# Get example gene interactions data
int <- system.file("extdata", "interactions.tsv", package = "CEMiTool")
int_df <- read.delim(int)
# Include interaction data into CEMiTool object
interactions_data(cem) <- int_df
# Plot resulting networks
cem <- plot_interactions(cem)
# Check resulting plot
show_plot(cem, "interaction")

}
