% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_gsea}
\alias{plot_gsea}
\alias{plot_gsea,CEMiTool-method}
\title{GSEA visualization}
\usage{
plot_gsea(cem, ...)

\S4method{plot_gsea}{CEMiTool}(cem, pv_cut = 0.05)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{pv_cut}{P-value cut-off. Default \code{0.05}}
}
\value{
Object of class \code{CEMiTool} with GSEA plots
}
\description{
Creates a heatmap with the results of gene set enrichment analysis (GSEA) of co-expression modules
}
\examples{
# Get example CEMiTool object
data(cem)
# Get example sample annotation file
# Run GSEA on network modules
cem <- mod_gsea(cem)
# Plot GSEA results
cem <- plot_gsea(cem)
# Check resulting plot
show_plot(cem, "gsea")

}
