% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{bnpathtest}
\alias{bnpathtest}
\title{bnpathtest}
\usage{
bnpathtest(
  results,
  exp,
  expSample = NULL,
  algo = "hc",
  algorithm.args = NULL,
  expRow = "ENSEMBL",
  cl = NULL,
  orgDb = org.Hs.eg.db,
  bypassConverting = FALSE,
  qvalueCutOff = 0.05,
  adjpCutOff = 0.05,
  nCategory = 15,
  Rrange = seq(2, 40, 2),
  scoreType = "aic-g"
)
}
\arguments{
\item{results}{the enrichment analysis result}

\item{exp}{gene expression matrix}

\item{expSample}{candidate rows to be included in the inference
default to all}

\item{algo}{structure learning method used in boot.strength()
default to "hc"}

\item{algorithm.args}{parameters to pass to
bnlearn structure learnng function}

\item{expRow}{the type of the identifier of rows of expression matrix}

\item{cl}{cluster object from parallel::makeCluster()}

\item{orgDb}{perform clusterProfiler::setReadable
based on this organism database}

\item{bypassConverting}{bypass symbol converting}

\item{qvalueCutOff}{the cutoff value for qvalue}

\item{adjpCutOff}{the cutoff value for adjusted pvalues}

\item{nCategory}{the number of pathways to be included}

\item{Rrange}{the sequence of R values to be tested}

\item{scoreType}{return the specified scores}
}
\value{
list of graphs and scores
}
\description{
Testing various R for bayesian network between pathways
}
\examples{
data("exampleEaRes");data("exampleGeneExp")
res <- bnpathtest(results = exampleEaRes, exp = exampleGeneExp,
       algo="hc", Rrange=seq(10, 30, 10), expRow = "ENSEMBL",
       scoreType="bge")
}
